# Generated by Django 3.2.13 on 2023-05-03 10:14

import django.contrib.gis.db.models.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import easy_thumbnails.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500, verbose_name='Name')),
                ('cp', models.CharField(max_length=5, verbose_name='CP')),
                ('province', models.CharField(max_length=100, verbose_name='Province')),
                ('point', django.contrib.gis.db.models.fields.PointField(srid=4326)),
                ('description', models.TextField(verbose_name='Description')),
                ('media', models.FileField(blank=True, null=True, upload_to='site_videos', validators=[django.core.validators.FileExtensionValidator(allowed_extensions=['mp4', 'avi', 'mov', 'webm', 'mkv'])], verbose_name='Video')),
            ],
            options={
                'verbose_name': 'City',
                'verbose_name_plural': 'Cities',
            },
        ),
        migrations.CreateModel(
            name='CityImage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', easy_thumbnails.fields.ThumbnailerImageField(upload_to='site_images')),
                ('city', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='images', to='cities.city', verbose_name='City')),
            ],
        ),
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('street', models.CharField(max_length=250, verbose_name='Street')),
                ('point', django.contrib.gis.db.models.fields.PointField(srid=4326)),
                ('google_place_id', models.CharField(blank=True, max_length=500, null=True)),
                ('details', models.CharField(blank=True, max_length=500, null=True)),
                ('number', models.CharField(blank=True, max_length=6, null=True)),
                ('door', models.CharField(blank=True, max_length=6, null=True)),
                ('floor', models.CharField(blank=True, max_length=100, null=True)),
                ('city', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='addresses', to='cities.city')),
            ],
            options={
                'verbose_name': 'Address',
                'verbose_name_plural': 'Addresses',
            },
        ),
    ]
