"""Format the response based on success/error"""
from rest_framework.response import Response
from rest_framework import status
import traceback
import logging

logger = logging.getLogger(__name__)

from rest_framework.response import Response
from rest_framework import status
import traceback
import logging

logger = logging.getLogger(__name__)

class CustomResponse:
    def __init__(
        self,
        has_error: bool = False,
        error_code: int = None,
        message: str = "success",
        response: dict = None,
        http_status: int = status.HTTP_200_OK,
        exception: Exception = None
    ):
        """Initialize the response object."""
        self.has_error = has_error
        self.error_code = error_code if has_error else -1
        self.message = message if message else "success"
        self.response = response or {}
        self.http_status = http_status
        self.exception = exception

    def format(self) -> Response:
        """Format and return the API response."""
        
        response_data = {
            "hasError": self.has_error,
            "errorCode": self.error_code,
            "message": self.message,
            "debugMessage": str(self.exception) if self.exception else "",
            "response": self.response,
        }

        if self.exception:
            if tb := traceback.extract_tb(self.exception.__traceback__):
                last_traceback = tb[-1]
                debugger = (
                    f"Error in file: {last_traceback.filename}, "
                    f"Line number: {last_traceback.lineno}, "
                    f"Cause: {last_traceback.line}, "
                    f"Message: {str(self.exception)}"
                )
                print(debugger)
                logger.error("Traceback Error: %s", debugger)

        return Response(response_data, status=self.http_status)
