from django.utils.translation import gettext_lazy as _

from local_secrets.sites.models import Site, TranslatedSite


class Event(Site):
    class Meta:
        proxy = True

        verbose_name = _('Event')
        verbose_name_plural = _('Events')


class TranslatedEvent(TranslatedSite):
    class Meta:
        proxy = True


class VendorEventPermissions:
    """
    This class is used to define the permissions for the VendorEvent model.
    It inherits from the Event model and adds a custom permission.
    """
    FREE = ['view_events']
    BASIC = FREE + ['create_events', 'edit_own_events', 'delete_events']
    PREMIUM = BASIC + ['featured_events', 'recurring_events']
    ENTERPRISE = PREMIUM + ['multiple_locations', 'bulk_events']
 