# local_secrets/payment/exceptions.py 
from django.utils.translation import gettext as _
from django.core.exceptions import ValidationError
from django.utils.translation import gettext_lazy as _
from typing import Dict, Any, Optional
from decimal import Decimal
from django.conf import settings
from django.core.cache import cache
from django.db import transaction
from django.db.models import Q
from django.urls import reverse
from django.core.mail import send_mail
from django.template.loader import render_to_string
from django.utils.html import strip_tags
from django.utils.translation import gettext as _ 

class PaymentError(Exception):
    """Base payment exception"""
    def __init__(self, message, code=None, params=None):
        super().__init__(message)
        self.message = message
        self.code = code
        self.params = params or {}

class CardDeclinedError(PaymentError):
    """Raised when card is declined"""
    pass

class CardValidationError(PaymentError):
    """Raised when card validation fails"""
    pass

class ProcessingError(PaymentError):
    """Raised when payment processing fails"""
    pass

PAYMENT_ERROR_MESSAGES = {
    'card_declined': {
        'general': 'Your card was declined.',
        'insufficient_funds': 'Your card has insufficient funds.',
        'expired_card': 'Your card has expired.',
        'incorrect_cvc': 'Your card\'s security code is incorrect.',
        'processing_error': 'An error occurred while processing your card.',
        'incorrect_number': 'Your card number is incorrect.'
    },
    'validation': {
        'invalid_number': 'The card number is not a valid credit card number.',
        'invalid_expiry_month': 'The card\'s expiration month is invalid.',
        'invalid_expiry_year': 'The card\'s expiration year is invalid.',
        'invalid_cvc': 'The card\'s security code is invalid.',
        'expired': 'The card has expired.'
    },
    'processing': {
        'try_again': 'An error occurred while processing your payment. Please try again.',
        'contact_support': 'An error occurred. Please contact support.',
        'already_processed': 'This payment has already been processed.'
    }
}
 
class PaymentGatewayError(Exception):
    """Base exception for payment gateway errors"""
    pass

class PaymentMethodError(PaymentGatewayError):
    """Exception for payment method related errors"""
    pass

class PaymentProcessingError(PaymentGatewayError):
    """Exception for payment processing errors"""
    pass

class InvalidConfigurationError(PaymentGatewayError):
    """Exception for configuration errors"""
    pass

class PaymentProcessError(PaymentProcessingError):
    """Exception for payment processing errors"""
    pass

class PaymentServiceError(PaymentProcessingError):
    """Exception for payment service errors"""
    pass

