# local_secrets/payment/filters.py

from django_filters import rest_framework as filters
from .models import VendorPayment

class PaymentFilterSet(filters.FilterSet):
    start_date = filters.DateFilter(field_name='created', lookup_expr='gte')
    end_date = filters.DateFilter(field_name='created', lookup_expr='lte')
    min_amount = filters.NumberFilter(field_name='total', lookup_expr='gte')
    max_amount = filters.NumberFilter(field_name='total', lookup_expr='lte')
    payment_type = filters.CharFilter(field_name='payment_type')
    status = filters.CharFilter(field_name='status')
    
    class Meta:
        model = VendorPayment
        fields = ['start_date', 'end_date', 'min_amount', 'max_amount', 
                 'payment_type', 'status']
