# Generated by Django 3.2.25 on 2025-05-12 12:28

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('address_line1', models.CharField(max_length=255)),
                ('address_line2', models.CharField(blank=True, max_length=255)),
                ('city', models.CharField(max_length=100)),
                ('state', models.CharField(blank=True, max_length=100)),
                ('postal_code', models.CharField(max_length=20)),
                ('country', models.CharField(default='US', max_length=3)),
                ('phone_number', models.CharField(blank=True, max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='AutomaticBilling',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(default=False)),
                ('billing_day', models.PositiveSmallIntegerField(help_text='Day of month for billing', validators=[django.core.validators.MaxValueValidator(31)])),
                ('next_billing_date', models.DateField()),
                ('gateway_subscription_id', models.CharField(blank=True, max_length=255)),
                ('gateway_status', models.CharField(blank=True, max_length=50)),
                ('gateway_error_message', models.TextField(blank=True)),
                ('syspay_subscription_id', models.CharField(blank=True, max_length=255)),
                ('syspay_mandate_id', models.CharField(blank=True, max_length=255)),
                ('retry_count', models.PositiveSmallIntegerField(default=0)),
                ('last_retry_date', models.DateTimeField(blank=True, null=True)),
                ('max_retries', models.PositiveSmallIntegerField(default=3)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Automatic Billing',
                'verbose_name_plural': 'Automatic Billings',
            },
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('currency', models.CharField(default='USD', max_length=3)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('processing', 'Processing'), ('completed', 'Completed'), ('failed', 'Failed'), ('refunded', 'Refunded'), ('disputed', 'Disputed'), ('dispute_resolved', 'Dispute Resolved'), ('partially_refunded', 'Partially Refunded')], default='pending', max_length=20)),
                ('payment_gateway_reference', models.CharField(blank=True, db_index=True, max_length=255)),
                ('syspay_transaction_id', models.CharField(blank=True, max_length=255)),
                ('syspay_payment_type', models.CharField(blank=True, max_length=50)),
                ('syspay_payment_status', models.CharField(blank=True, max_length=50)),
                ('amount_refunded', models.DecimalField(decimal_places=2, default=0, max_digits=10)),
                ('refund_reason', models.CharField(blank=True, max_length=255)),
                ('error_message', models.TextField(blank=True)),
                ('has_dispute', models.BooleanField(default=False)),
                ('dispute_reason', models.CharField(blank=True, max_length=255)),
                ('dispute_created_at', models.DateTimeField(blank=True, null=True)),
                ('dispute_resolved_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Payment',
                'verbose_name_plural': 'Payments',
            },
        ),
        migrations.CreateModel(
            name='PaymentDispute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reason', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('resolved_at', models.DateTimeField(blank=True, null=True)),
                ('status', models.CharField(default='open', max_length=20)),
            ],
            options={
                'verbose_name': 'Dispute',
                'verbose_name_plural': 'Disputes',
            },
        ),
        migrations.CreateModel(
            name='PaymentMethod',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payment_type', models.CharField(choices=[('stripe', 'Stripe'), ('paypal', 'PayPal'), ('syspay', 'SysPay'), ('razorpay', 'Razorpay')], max_length=20)),
                ('is_default', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('gateway_payment_method_id', models.CharField(max_length=255)),
                ('gateway_customer_id', models.CharField(blank=True, max_length=255)),
                ('gateway_status', models.CharField(blank=True, max_length=50)),
                ('stripe_payment_method_id', models.CharField(blank=True, max_length=255)),
                ('paypal_payment_method_id', models.CharField(blank=True, max_length=255)),
                ('razorpay_payment_method_id', models.CharField(blank=True, max_length=255)),
                ('syspay_payment_method_id', models.CharField(blank=True, max_length=255)),
                ('syspay_user_id', models.CharField(blank=True, max_length=255)),
                ('syspay_status', models.CharField(blank=True, choices=[('pending', 'Pending'), ('active', 'Active'), ('suspended', 'Suspended'), ('terminated', 'Terminated')], max_length=50)),
                ('syspay_onboarding_complete', models.BooleanField(default=False)),
                ('syspay_onboarding_url', models.URLField(blank=True)),
                ('syspay_onboarding_error', models.CharField(blank=True, max_length=255)),
                ('is_verified', models.BooleanField(default=False)),
                ('verification_error', models.CharField(blank=True, max_length=255)),
            ],
            options={
                'verbose_name': 'Payment Method',
                'verbose_name_plural': 'Payment Methods',
            },
        ),
        migrations.CreateModel(
            name='PaymentRefund',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('reason', models.CharField(blank=True, max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Refund',
                'verbose_name_plural': 'Refunds',
            },
        ),
        migrations.CreateModel(
            name='PaymentTransaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('transaction_id', models.CharField(max_length=255, unique=True)),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('status', models.CharField(default='pending', max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Transaction',
                'verbose_name_plural': 'Transactions',
            },
        ),
        migrations.CreateModel(
            name='VendorPayment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('variant', models.CharField(max_length=255)),
                ('status', models.CharField(choices=[('waiting', 'Waiting for confirmation'), ('preauth', 'Pre-authorized'), ('confirmed', 'Confirmed'), ('rejected', 'Rejected'), ('refunded', 'Refunded'), ('error', 'Error'), ('input', 'Input')], default='waiting', max_length=10)),
                ('fraud_status', models.CharField(choices=[('unknown', 'Unknown'), ('accept', 'Passed'), ('reject', 'Rejected'), ('review', 'Review')], default='unknown', max_length=10, verbose_name='fraud check')),
                ('fraud_message', models.TextField(blank=True, default='')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('transaction_id', models.CharField(blank=True, max_length=255)),
                ('currency', models.CharField(max_length=10)),
                ('total', models.DecimalField(decimal_places=2, default='0.0', max_digits=9)),
                ('delivery', models.DecimalField(decimal_places=2, default='0.0', max_digits=9)),
                ('tax', models.DecimalField(decimal_places=2, default='0.0', max_digits=9)),
                ('description', models.TextField(blank=True, default='')),
                ('billing_first_name', models.CharField(blank=True, max_length=256)),
                ('billing_last_name', models.CharField(blank=True, max_length=256)),
                ('billing_address_1', models.CharField(blank=True, max_length=256)),
                ('billing_address_2', models.CharField(blank=True, max_length=256)),
                ('billing_city', models.CharField(blank=True, max_length=256)),
                ('billing_postcode', models.CharField(blank=True, max_length=256)),
                ('billing_country_code', models.CharField(blank=True, max_length=2)),
                ('billing_country_area', models.CharField(blank=True, max_length=256)),
                ('billing_email', models.EmailField(blank=True, max_length=254)),
                ('customer_ip_address', models.GenericIPAddressField(blank=True, null=True)),
                ('extra_data', models.TextField(blank=True, default='')),
                ('message', models.TextField(blank=True, default='')),
                ('token', models.CharField(blank=True, default='', max_length=36)),
                ('captured_amount', models.DecimalField(decimal_places=2, default='0.0', max_digits=9)),
                ('has_dispute', models.BooleanField(default=False)),
                ('dispute_reason', models.CharField(blank=True, max_length=255)),
                ('dispute_created_at', models.DateTimeField(blank=True, null=True)),
                ('dispute_resolved_at', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
