# Generated by Django 3.2.25 on 2025-04-03 09:40

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('users', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='PaymentMethod',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payment_type', models.CharField(choices=[('stripe', 'Stripe'), ('paypal', 'PayPal'), ('syspay', 'SysPay'), ('razorpay', 'Razorpay')], max_length=20)),
                ('is_default', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('stripe_payment_method_id', models.CharField(blank=True, max_length=255)),
                ('paypal_payment_method_id', models.CharField(blank=True, max_length=255)),
                ('razorpay_payment_method_id', models.CharField(blank=True, max_length=255)),
                ('syspay_payment_method_id', models.CharField(blank=True, max_length=255)),
                ('is_verified', models.BooleanField(default=False)),
                ('verification_error', models.CharField(blank=True, max_length=255)),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='payment_methods', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Payment Method',
                'verbose_name_plural': 'Payment Methods',
            },
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('currency', models.CharField(default='USD', max_length=3)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('processing', 'Processing'), ('completed', 'Completed'), ('failed', 'Failed'), ('refunded', 'Refunded'), ('disputed', 'Disputed'), ('dispute_resolved', 'Dispute Resolved'), ('partially_refunded', 'Partially Refunded')], default='pending', max_length=20)),
                ('payment_gateway_reference', models.CharField(blank=True, max_length=255)),
                ('amount_refunded', models.DecimalField(decimal_places=2, default=0, max_digits=10)),
                ('refund_reason', models.CharField(blank=True, max_length=255)),
                ('error_message', models.TextField(blank=True)),
                ('has_dispute', models.BooleanField(default=False)),
                ('dispute_reason', models.CharField(blank=True, max_length=255)),
                ('dispute_created_at', models.DateTimeField(blank=True, null=True)),
                ('dispute_resolved_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                ('payment_method', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='payment.paymentmethod')),
                ('subscription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='users.vendorsubscription')),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='payments', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Payment',
                'verbose_name_plural': 'Payments',
            },
        ),
        migrations.CreateModel(
            name='AutomaticBilling',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(default=False)),
                ('billing_day', models.PositiveSmallIntegerField(help_text='Day of month for billing', validators=[django.core.validators.MaxValueValidator(31)])),
                ('next_billing_date', models.DateField()),
                ('retry_count', models.PositiveSmallIntegerField(default=0)),
                ('last_retry_date', models.DateTimeField(blank=True, null=True)),
                ('max_retries', models.PositiveSmallIntegerField(default=3)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('payment_method', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='payment.paymentmethod')),
                ('vendor', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='automatic_billing', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Automatic Billing',
                'verbose_name_plural': 'Automatic Billings',
            },
        ),
        migrations.AddIndex(
            model_name='payment',
            index=models.Index(fields=['payment_gateway_reference'], name='payment_pay_payment_53953e_idx'),
        ),
        migrations.AddIndex(
            model_name='payment',
            index=models.Index(fields=['status'], name='payment_pay_status_124d3d_idx'),
        ),
        migrations.AddIndex(
            model_name='payment',
            index=models.Index(fields=['created_at'], name='payment_pay_created_671024_idx'),
        ),
    ]
