# local_secrets/payment/tests/conftest.py

import pytest
from django.db import connection

@pytest.fixture(scope='session')
def django_db_setup(django_db_setup, django_db_blocker):
    """Set up test database with PostGIS extensions"""
    with django_db_blocker.unblock():
        with connection.cursor() as cursor:
            cursor.execute("CREATE EXTENSION IF NOT EXISTS postgis;")
            cursor.execute("CREATE EXTENSION IF NOT EXISTS postgis_topology;")

@pytest.fixture(autouse=True)
def enable_db_access_for_all_tests(db):
    """Enable database access for all tests"""
    pass

@pytest.fixture
def mock_syspay_response():
    """Mock SysPay API response"""
    return {
        'id': 'test_id',
        'status': 'success',
        'amount': '100.00',
        'currency': 'USD'
    }
