# local_secrets/payment/tests/manual_test.py

import os
import django
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'config.settings.local')
django.setup()

from local_secrets.payment.providers.syspay_provider import SysPayProvider
from local_secrets.payment.models import Payment, PaymentMethod
from local_secrets.users.models import Vendor

def test_syspay_integration():
    """Manual test for SysPay integration"""
    
    try:
        # Initialize provider
        provider = SysPayProvider()
        print("✓ Provider initialized")

        # Test API connection
        provider.test_connection()
        print("✓ API connection successful")

        # Create test vendor
        vendor = Vendor.objects.get_or_create(
            company_name="Test Company",
            contact_email="test@example.com"
        )[0]
        print("✓ Test vendor created")

        # Create payment method
        payment_method = PaymentMethod.objects.create(
            vendor=vendor,
            payment_type='syspay',
            syspay_payment_method_id='pm_test_123',
            is_active=True,
            is_verified=True,
            last4='4242'
        )
        print("✓ Test payment method created")

        # Create test payment
        payment = Payment.objects.create(
            vendor=vendor,
            payment_method=payment_method,
            amount=1000,  # €10.00
            currency='EUR'
        )
        print("✓ Test payment created")

        # Process payment
        result = provider.process_payment(payment)
        print(f"✓ Payment processed. Status: {result['status']}")

        return True

    except Exception as e:
        print(f"❌ Error: {str(e)}")
        return False

if __name__ == "__main__":
    print("Starting SysPay integration test...")
    success = test_syspay_integration()
    print(f"\nTest {'succeeded' if success else 'failed'}")
    print("Test completed.")
    print("Exiting...")