# local_secrets/payment/tests/test_syspay_integration.py

import pytest
from django.utils import timezone
from ..exceptions import PaymentGatewayError
# local_secrets/payment/tests/test_syspay_integration.py

import pytest
from django.utils import timezone
from ..exceptions import PaymentGatewayError
from ..providers.syspay_provider import SysPayProvider

pytestmark = pytest.mark.django_db

@pytest.fixture
def mock_syspay_requests(mocker):
    """Mock SysPay API requests"""
    def mock_response(*args, **kwargs):
        class MockResponse:
            def __init__(self, json_data, status_code=200):
                self.json_data = json_data
                self.status_code = status_code
            
            def json(self):
                return self.json_data
            
            def raise_for_status(self):
                if self.status_code >= 400:
                    raise requests.exceptions.HTTPError()
        
        # Mock different endpoints
        if 'users' in args[1]:
            return MockResponse({'id': 'test_user_id'})
        elif 'onboarding' in args[1]:
            return MockResponse({'url': 'https://test.onboarding.url'})
        elif 'payment-methods' in args[1]:
            return MockResponse({'id': 'test_payment_method_id'})
        elif 'payments' in args[1]:
            return MockResponse({'id': 'test_payment_id', 'status': 'completed'})
        
        return MockResponse({})
    
    mocker.patch('requests.request', side_effect=mock_response)

class TestSysPayIntegration:
    def test_create_user(self, syspay_provider, mock_syspay_requests):
        test_user_data = {
            "email": f"test_{timezone.now().timestamp()}@example.com",
            "first_name": "Test",
            "last_name": "User",
            "reference": f"TEST_USER_{timezone.now().timestamp()}"
        }
        
        response = syspay_provider.create_user(test_user_data)
        assert 'id' in response
        assert response['id'] == 'test_user_id'

    def test_get_onboarding_link(self, syspay_provider, mock_syspay_requests):
        response = syspay_provider.get_onboarding_link('test_user_id')
        assert 'url' in response
        assert response['url'].startswith('https://')

    def test_create_payment_method(self, syspay_provider, mock_syspay_requests):
        test_card = {
            'number': '4111111111111111',
            'expiry_month': '12',
            'expiry_year': '2025',
            'cvv': '123'
        }
        
        response = syspay_provider.create_payment_method('test_user_id', test_card)
        assert 'id' in response
        assert response['id'] == 'test_payment_method_id'

    def test_process_payment(self, syspay_provider, mock_syspay_requests):
        payment_data = {
            "amount": 1000,
            "currency": "EUR",
            "payment_method_id": "test_payment_method_id",
            "description": "Test payment"
        }
        
        response = syspay_provider.process_payment(payment_data)
        assert 'id' in response
        assert response['status'] == 'completed'
 