# local_secrets/payment/urls.py

from django.urls import path, include
from rest_framework.routers import DefaultRouter
from django.conf import settings
from .views import (
    PaymentViewSet,  
    TestPaymentInterface, 
    TestPaymentProcessView,
    PaymentCreateView,
    PaymentSuccessView,
    PaymentFailureView, 
    VendorPaymentListView,
    VendorPaymentDetailView,
    PaymentMethodViewSet, 
    WebhookView,
    StripeTestInterface, StripeTestPaymentView, 
    ProcessVendorSubscriptionView,
    VendorSubscriptionTestView
)

app_name = 'payment'

# Create a router for viewsets
router = DefaultRouter()
router.register(r'payments', PaymentViewSet, basename='payment')

urlpatterns = [
    # Test interface patterns - Debug mode only
    path('test/', TestPaymentInterface.as_view(), name='test_interface'),
    path('test/process/', TestPaymentProcessView.as_view(), name='test_process'),
    path('stripe/test/', StripeTestInterface.as_view(), name='stripe_test_interface'),
    path('stripe/test/process/', StripeTestPaymentView.as_view(), name='stripe_test_process'),

    path('vendor-subscription/test/', 
         VendorSubscriptionTestView.as_view(), 
         name='vendor_subscription_test'),
    path('vendor-subscription/process/', 
         ProcessVendorSubscriptionView.as_view(), 
         name='process_vendor_subscription'),

    # Payment methods
    path('payment-methods/', 
         PaymentMethodViewSet.as_view({
             'get': 'list_payment_methods',
             'post': 'add_payment_method'
         }), 
         name='payment-methods'),
    
    path('payment-methods/<int:pk>/',
         PaymentMethodViewSet.as_view({
             'delete': 'remove_payment_method',
             'put': 'update_payment_method'
         }), 
         name='payment-method-detail'),

    # Vendor payments
    path('vendor-payments/<int:pk>/',
         VendorPaymentDetailView.as_view(), 
         name='vendor-payment-detail'),

    # Webhooks
    path('webhooks/<str:gateway_name>/', 
         WebhookView.as_view(), 
         name='payment-webhook'),

    # Include router URLs
    path('', include(router.urls)),

    # Include django-payments core URLs
    path('', include('payments.urls')),
]
