class ImageDownloadException(Exception):
    """Custom exception for image download errors."""

    def __init__(self, message, status_code=None, url=None):
        self.message = message
        self.status_code = status_code
        self.url = url
        super().__init__(self.message)

    def __str__(self):
        details = f"Error: {self.message}"
        if self.status_code:
            details += f" | HTTP Status: {self.status_code}"
        if self.url:
            details += f" | URL: {self.url}"
        return details
