from drf_yasg import openapi


def manual_params(custom_headers=[]):
    params = [
        openapi.Parameter(
            name="X-Signature",
            in_=openapi.IN_HEADER,
            type=openapi.TYPE_STRING,
            required=True,
            description="Signature for request validation",
        ),
        openapi.Parameter(
            name="X-Timestamp",
            in_=openapi.IN_HEADER,
            type=openapi.TYPE_STRING,
            required=True,
            description="Timestamp of the request",
        ),
    ]

    if "language" in custom_headers:
        params.append(openapi.Parameter(
            name="language",
            in_=openapi.IN_QUERY,
            type=openapi.TYPE_STRING,
            required=True,
            description="Language for the response (e.g., 'en', 'es', 'fr')",
        ))

    if "country" in custom_headers:
        params.append(openapi.Parameter(
            name="country_id",
            in_=openapi.IN_QUERY,
            type=openapi.TYPE_STRING,
            required=True,
            description="",
        ))

    if "level" in custom_headers:
        params.append(openapi.Parameter(
            name="level_id",
            in_=openapi.IN_QUERY,
            type=openapi.TYPE_STRING,
            required=True,
            description="",
        ))

    if "category" in custom_headers:
        params.append(openapi.Parameter(
            name="category_id",
            in_=openapi.IN_QUERY,
            type=openapi.TYPE_STRING,
            required=True,
            description="",
        ))

    return params
