from rest_framework import serializers


class CountryDataSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    name = serializers.CharField()
    code = serializers.CharField()
    phone_code = serializers.CharField()
    ls_id = serializers.IntegerField()


class UserDataSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    username = serializers.CharField()
    email = serializers.EmailField()
    is_superuser = serializers.BooleanField()
    is_staff = serializers.BooleanField()
    is_active = serializers.BooleanField()
    date_joined = serializers.DateTimeField()
    last_login = serializers.DateTimeField()
    groups = serializers.ListField(
        child=serializers.CharField(),
        required=False)
    user_permissions = serializers.ListField(
        child=serializers.CharField(), required=False)


class AutomationMappingSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    status = serializers.ChoiceField(choices=["IN_PRODUCTION", "DRAFT"])
    site_types = serializers.CharField()
    task = serializers.IntegerField()
    project_title = serializers.CharField()
    level = serializers.CharField()
    translated_level = serializers.CharField(allow_null=True)
    main_category = serializers.CharField()
    translated_main_category = serializers.CharField(allow_null=True)
    tailored_category = serializers.CharField()
    translated_tailored_category = serializers.CharField(allow_null=True)
    search_string = serializers.CharField()
    rank = serializers.IntegerField()
    search_page_url = serializers.URLField(allow_null=True)
    is_advertisement = serializers.BooleanField()
    title = serializers.CharField()
    translated_title = serializers.CharField(allow_null=True)
    description = serializers.CharField()
    translated_description = serializers.CharField(allow_null=True)
    price = serializers.CharField()
    category_name = serializers.CharField()
    address = serializers.CharField()
    neighborhood = serializers.CharField(allow_null=True)
    street = serializers.CharField()
    city = serializers.CharField()
    state = serializers.CharField()
    postal_code = serializers.CharField()
    country = CountryDataSerializer()
    form_country_id = serializers.IntegerField()
    form_country_name = serializers.CharField()
    form_destination_id = serializers.IntegerField()
    form_destination_name = serializers.CharField()
    destination = serializers.CharField(allow_null=True)
    country_code = serializers.CharField(allow_null=True)
    phone = serializers.CharField()
    latitude = serializers.FloatField()
    longitude = serializers.FloatField()
    place_id = serializers.CharField()
    data_id = serializers.CharField()
    data_cid = serializers.CharField()
    reviews_count = serializers.IntegerField()
    rating = serializers.FloatField()
    scraped_at = serializers.DateTimeField()
    url = serializers.URLField(allow_null=True)
    website = serializers.URLField(allow_null=True)
    thumbnail = serializers.URLField()
    operating_hours = serializers.DictField()
    service_options = serializers.CharField(allow_null=True)
    title_esp = serializers.CharField()
    title_fr = serializers.CharField()
    title_eng = serializers.CharField()
    description_esp = serializers.CharField()
    description_eng = serializers.CharField()
    description_fr = serializers.CharField()
    is_deleted = serializers.BooleanField()
    level_id = serializers.IntegerField()
    category_id = serializers.IntegerField()
    sub_category_id = serializers.IntegerField()
    city_id = serializers.IntegerField()
    country_id = serializers.IntegerField()
    user = UserDataSerializer()
    types_esp = serializers.CharField()
    types_fr = serializers.CharField()
    types_en = serializers.CharField()
    types = serializers.CharField()
    images_urls = serializers.ListField(child=serializers.URLField())


class LanguageSerializer(serializers.Serializer):
    language = serializers.CharField()


class CountrySerializer(serializers.Serializer):
    id = serializers.IntegerField()
    name = serializers.CharField()
    country__id = serializers.IntegerField(
        required=False,
        help_text=("The ID of the parent country. This field is only present when the data is pulled from a translation. "
                   "If the field is missing, it indicates that the data is not associated with a parent country or the language does not require this mapping.")

    )  # Optional field
    code = serializers.CharField()
    phone_code = serializers.CharField()


class CitySerializer(serializers.Serializer):
    id = serializers.IntegerField()
    name = serializers.CharField()
    province = serializers.CharField()
    description = serializers.CharField()
    slogan = serializers.CharField()
    link = serializers.CharField()
    latitude = serializers.DecimalField(max_digits=30, decimal_places=27)
    longitude = serializers.DecimalField(max_digits=30, decimal_places=27)
    city__id = serializers.IntegerField(
        required=False,
        help_text=(
            "The ID of the parent city. This field is only present when the data is pulled from a translation. "
            "If the field is missing, it indicates that the data is not associated with a parent city or the language does not require this mapping.")
    )  # Optional field


class LevelSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    title = serializers.CharField()
    level__id = serializers.IntegerField(
        required=False,
        help_text=(
            "The ID of the parent level. This field is only present when the data is pulled from a translation. "
            "If the field is missing, it indicates that the data is not associated with a parent level or the language does not require this mapping.")
    )  # Optional field


class CategorySerializer(serializers.Serializer):
    id = serializers.IntegerField()
    title = serializers.CharField()
    category__id = serializers.IntegerField(
        required=False,
        help_text=(
            "The ID of the parent category. This field is only present when the data is pulled from a translation. "
            "If the field is missing, it indicates that the data is not associated with a parent category or the language does not require this mapping.")
    )  # Optional field


class SubCategorySerializer(serializers.Serializer):
    id = serializers.IntegerField()
    title = serializers.CharField()
    subcategory__id = serializers.IntegerField(
        required=False,
        help_text=("The ID of the parent sub category. This field is only present when the data is pulled from a translation. "
                   "If the field is missing, it indicates that the data is not associated with a parent sub category or the language does not require this mapping.")
    )  # Optional field
