# local_secrets/sites/constants.py
from local_secrets.sites.models import SiteVisibilityState


SITE_STATE_TRANSITIONS = {
    SiteVisibilityState.DRAFT: {
        SiteVisibilityState.PENDING_REVIEW,
        SiteVisibilityState.ARCHIVED
    },
    SiteVisibilityState.PENDING_REVIEW: {
        SiteVisibilityState.APPROVED,
        SiteVisibilityState.DRAFT,
        SiteVisibilityState.ARCHIVED
    },
    SiteVisibilityState.APPROVED: {
        SiteVisibilityState.ACTIVE,
        SiteVisibilityState.INACTIVE,
        SiteVisibilityState.ARCHIVED
    },
    SiteVisibilityState.ACTIVE: {
        SiteVisibilityState.INACTIVE,
        SiteVisibilityState.SUSPENDED,
        SiteVisibilityState.ARCHIVED
    },
    SiteVisibilityState.INACTIVE: {
        SiteVisibilityState.ACTIVE,
        SiteVisibilityState.ARCHIVED
    },
    SiteVisibilityState.SUSPENDED: {
        SiteVisibilityState.ACTIVE,
        SiteVisibilityState.INACTIVE,
        SiteVisibilityState.ARCHIVED
    },
    SiteVisibilityState.ARCHIVED: {
        SiteVisibilityState.DRAFT
    }
}
