# Generated by Django 3.2.25 on 2025-05-12 12:28

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.expressions
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('users', '0022_auto_20250512_1758'),
        ('sites', '0054_auto_20250512_1758'),
    ]

    operations = [
        migrations.AddField(
            model_name='site',
            name='active_subscription',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='active_sites', to='users.vendorsubscription'),
        ),
        migrations.AddField(
            model_name='site',
            name='created_at',
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='site',
            name='is_vendor_featured',
            field=models.BooleanField(default=False, verbose_name='Vendor Featured'),
        ),
        migrations.AddField(
            model_name='site',
            name='last_status_change',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='site',
            name='last_update_attempt',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='site',
            name='price',
            field=models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True, verbose_name='Regular Price'),
        ),
        migrations.AddField(
            model_name='site',
            name='published_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='site',
            name='review_feedback',
            field=models.TextField(blank=True, null=True, verbose_name='Review Feedback'),
        ),
        migrations.AddField(
            model_name='site',
            name='reviewed_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='site',
            name='reviewed_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='reviewed_sites', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='site',
            name='state_change_reason',
            field=models.CharField(blank=True, max_length=255),
        ),
        migrations.AddField(
            model_name='site',
            name='state_changed_at',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='site',
            name='state_changed_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='site_state_changes', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='site',
            name='status',
            field=models.CharField(choices=[('draft', 'Draft'), ('pending_review', 'Pending Review'), ('rejected', 'Rejected'), ('approved', 'Approved'), ('published', 'Published'), ('unpublished', 'Unpublished'), ('suspended', 'Suspended')], db_index=True, default='draft', max_length=20),
        ),
        migrations.AddField(
            model_name='site',
            name='status_change_reason',
            field=models.CharField(blank=True, max_length=100),
        ),
        migrations.AddField(
            model_name='site',
            name='subscription_state',
            field=models.CharField(choices=[('none', 'No Subscription'), ('trial', 'Trial'), ('active', 'Active'), ('past_due', 'Past Due'), ('cancelled', 'Cancelled'), ('expired', 'Expired'), ('suspended', 'Suspended')], db_index=True, default='none', max_length=20),
        ),
        migrations.AddField(
            model_name='site',
            name='subscription_status',
            field=models.CharField(choices=[('free', 'Free'), ('trial', 'Trial'), ('active', 'Active'), ('expired', 'Expired'), ('cancelled', 'Cancelled')], db_index=True, default='free', max_length=20),
        ),
        migrations.AddField(
            model_name='site',
            name='unpublished_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='site',
            name='update_attempts',
            field=models.IntegerField(default=0),
        ),
        migrations.AddField(
            model_name='site',
            name='updated_at',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name='site',
            name='vendor',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='vendor_sites', to='users.vendor', verbose_name='Vendor'),
        ),
        migrations.AddField(
            model_name='site',
            name='vendor_contact_info',
            field=models.CharField(blank=True, max_length=500, verbose_name='Vendor Contact Info'),
        ),
        migrations.AddField(
            model_name='site',
            name='vendor_notes',
            field=models.TextField(blank=True, verbose_name='Vendor Notes'),
        ),
        migrations.AddField(
            model_name='site',
            name='view_count',
            field=models.PositiveIntegerField(default=0, verbose_name='View Count'),
        ),
        migrations.AddField(
            model_name='site',
            name='visibility',
            field=models.CharField(choices=[('visible', 'Visible'), ('hidden', 'Hidden'), ('subscription_expired', 'Subscription Expired'), ('payment_pending', 'Payment Pending')], db_index=True, default='hidden', max_length=20),
        ),
        migrations.AddField(
            model_name='site',
            name='visibility_changed_at',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='site',
            name='visibility_state',
            field=models.CharField(choices=[('draft', 'Draft'), ('pending_review', 'Pending Review'), ('approved', 'Approved'), ('active', 'Active'), ('inactive', 'Inactive'), ('suspended', 'Suspended'), ('archived', 'Archived')], db_index=True, default='draft', max_length=20),
        ),
        migrations.AddField(
            model_name='site',
            name='visibility_update_pending',
            field=models.BooleanField(default=False),
        ),
        migrations.AddIndex(
            model_name='site',
            index=models.Index(fields=['status'], name='sites_site_status_79a98b_idx'),
        ),
        migrations.AddIndex(
            model_name='site',
            index=models.Index(fields=['subscription_status'], name='sites_site_subscri_7596fb_idx'),
        ),
        migrations.AddIndex(
            model_name='site',
            index=models.Index(fields=['created_at'], name='sites_site_created_edd89b_idx'),
        ),
        migrations.AddIndex(
            model_name='site',
            index=models.Index(fields=['visibility', 'status'], name='sites_site_visibil_ae4d14_idx'),
        ),
        migrations.AddIndex(
            model_name='site',
            index=models.Index(fields=['visibility_state', 'subscription_state'], name='sites_site_visibil_02a392_idx'),
        ),
        migrations.AddIndex(
            model_name='site',
            index=models.Index(fields=['state_changed_at'], name='sites_site_state_c_3826f0_idx'),
        ),
        migrations.AddIndex(
            model_name='site',
            index=models.Index(fields=['price'], name='sites_site_price_85a826_idx'),
        ),
        migrations.AddIndex(
            model_name='site',
            index=models.Index(fields=['vendor', 'subscription_status', 'status'], name='sites_site_vendor__95f556_idx'),
        ),
        # migrations.AddConstraint(
        #     model_name='site',
        #     constraint=models.UniqueConstraint(fields=('title', 'type'), name='unique_site_title_type'),
        # ),
        migrations.AddConstraint(
            model_name='site',
            constraint=models.CheckConstraint(check=models.Q(('type__in', ['place', 'event'])), name='valid_site_type'),
        ),
        migrations.AddField(
            model_name='siteviewlog',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='view_logs', to='sites.site'),
        ),
        migrations.AddField(
            model_name='siteviewlog',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='site_views', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='sitestatushistory',
            name='changed_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='sitestatushistory',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='status_history', to='sites.site'),
        ),
        migrations.AddField(
            model_name='sitestatelog',
            name='changed_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='sitestatelog',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='state_logs', to='sites.site'),
        ),
        migrations.AddField(
            model_name='sitereview',
            name='checklist_items',
            field=models.ManyToManyField(through='sites.ReviewChecklistResponse', to='sites.ReviewChecklistItem', verbose_name='Checklist Items'),
        ),
        migrations.AddField(
            model_name='sitereview',
            name='reviewer',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='site_reviews', to=settings.AUTH_USER_MODEL, verbose_name='Reviewer'),
        ),
        migrations.AddField(
            model_name='sitereview',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reviews', to='sites.site', verbose_name='Site'),
        ),
        migrations.AddField(
            model_name='reviewchecklistresponse',
            name='checklist_item',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sites.reviewchecklistitem', verbose_name='Checklist Item'),
        ),
        migrations.AddField(
            model_name='reviewchecklistresponse',
            name='review',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='checklist_responses', to='sites.sitereview', verbose_name='Review'),
        ),
        migrations.AddField(
            model_name='promotion',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='promotions', to='sites.site', verbose_name='Site'),
        ),
        migrations.AddField(
            model_name='promotion',
            name='vendor',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='site_promotions', to='users.vendor', verbose_name='Vendor'),
        ),
        migrations.AddIndex(
            model_name='siteviewlog',
            index=models.Index(fields=['site', 'viewed_at'], name='sites_sitev_site_id_d356f0_idx'),
        ),
        migrations.AddIndex(
            model_name='siteviewlog',
            index=models.Index(fields=['ip_address'], name='sites_sitev_ip_addr_6a2ebb_idx'),
        ),
        migrations.AddIndex(
            model_name='siteviewlog',
            index=models.Index(fields=['user'], name='sites_sitev_user_id_f8edcd_idx'),
        ),
        migrations.AddIndex(
            model_name='sitestatushistory',
            index=models.Index(fields=['site', 'status'], name='sites_sites_site_id_5454c6_idx'),
        ),
        migrations.AddIndex(
            model_name='sitestatushistory',
            index=models.Index(fields=['changed_at'], name='sites_sites_changed_09603a_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='reviewchecklistresponse',
            unique_together={('review', 'checklist_item')},
        ),
        migrations.AddIndex(
            model_name='promotion',
            index=models.Index(fields=['vendor', 'site', 'is_active'], name='sites_promo_vendor__7e525d_idx'),
        ),
        migrations.AddIndex(
            model_name='promotion',
            index=models.Index(fields=['start_date', 'end_date'], name='sites_promo_start_d_1a0eff_idx'),
        ),
        migrations.AddConstraint(
            model_name='promotion',
            constraint=models.CheckConstraint(check=models.Q(('end_date__gt', django.db.models.expressions.F('start_date'))), name='end_date_after_start_date'),
        ),
        migrations.AddConstraint(
            model_name='promotion',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('discount_type', 'percentage'), ('discount_value__gte', 0), ('discount_value__lte', 100)), models.Q(('discount_type', 'fixed'), ('discount_value__gte', 0)), _connector='OR'), name='valid_discount_value'),
        ),
    ]
