# local_secrets/sites/urls.py
from django.urls import path, include, re_path
from django.contrib.auth.decorators import login_required
from local_secrets.sites import views
from rest_framework import routers
from local_secrets.sites.api_views import UnifiedSearchViewSet, SiteSearchView

router = routers.DefaultRouter(trailing_slash=False)

router.register(r'categories', views.CategoryViewSet, basename='Categories')
router.register(r'comments', views.CommentViewSet, basename='Comments')
router.register(r'default_images', views.DefaultImageViewSet, basename='DefaultImages')
router.register(r'vendor/sites', views.VendorSiteViewSet, basename='vendor-sites')
router.register(r'', views.SiteViewSet, basename='Sites')
router.register(r'site-visibility', views.SiteVisibilityViewSet, basename='site-visibility')
router.register(r'promotions', views.SitePromotionViewSet, basename='promotion')
router.register(r'unified-search', UnifiedSearchViewSet, basename='unified-search')

urlpatterns = [
    # DRF Router URLs
    path('', include(router.urls)),

    # Other API Endpoints
    #path('<slug:slug>/', views.SiteViewSet.as_view({'get': 'retrieve_by_slug'}), name='site-detail-by-slug'),
    path('near-me/', views.SiteViewSet.as_view({'get': 'near_me'}), name='sites-near-me'),
    path('discover-around-me/', views.SiteViewSet.as_view({'get': 'discover_around_me'}), name='discover-around-me'),

    # Autocomplete Endpoints
    re_path(r'^category-autocomplete/$', views.CategoryAutocomplete.as_view(), name='category-autocomplete'),
    re_path(r'^level-autocomplete/$', views.LevelAutocomplete.as_view(), name='level-autocomplete'),
    re_path(r'^place-level-autocomplete/$', views.PlaceLevelAutocomplete.as_view(), name='place-level-autocomplete'),
    re_path(r'^event-level-autocomplete/$', views.EventLevelAutocomplete.as_view(), name='event-level-autocomplete'),
    re_path(r'^subcategory-autocomplete/$', views.SubCategoryAutocomplete.as_view(), name='subcategory-autocomplete'),

    # Vendor Sites
    re_path(r'^vendor/sites/list/', views.VendorSiteListView.as_view(), name='vendor-site-list'),
    re_path(r'^vendor/sites/<int:pk>/', views.VendorSiteDetailView.as_view(), name='vendor-site-detail'),

    # Template-based Unified Search View
    path('sites/unified-search-template/', views.unified_search_view, name='unified-search-template'),
    path('search/sites/<str:search_type>/<str:keyword>/', SiteSearchView.as_view(), name='site-search'),
    path('search/sites/', views.SiteSearchTemplateView.as_view(), name='site-search-template'),
    path('search/sites/<str:search_type>/', views.SiteSearchTemplateView.as_view(), name='site-search-type'),
 
    # Reviews
    path('reviews/', include([
        path('', login_required(views.SiteReviewViewSet.as_view({'get': 'list'})), name='review-list'),
        path('<int:pk>/', login_required(views.SiteReviewViewSet.as_view({
            'get': 'retrieve',
            'put': 'update',
            'patch': 'partial_update',
        })), name='review-detail'),
        path('<int:pk>/submit/', login_required(views.SiteReviewViewSet.as_view({
            'post': 'submit_review',
        })), name='review-submit'),
    ])),

    # Smart Search API
    path('api/smart-search/', views.SmartSiteSearch.as_view(), name='smart-search'),

    # Analytics Dashboard
    path('analytics/', views.SiteViewLogView.as_view(), name='site_analytics_dashboard'),
    # Add to urlpatterns
 
]