from django.utils.translation import gettext_lazy as _
from django.db import models

class VendorSubscriptionType(models.TextChoices):
    FREE = 'free', _('Free')
    BASIC = 'basic', _('Basic')
    PREMIUM = 'premium', _('Premium')
    ENTERPRISE = 'enterprise', _('Enterprise')
 
class VendorVerificationStatus(models.TextChoices):
    PENDING = 'pending', _('Pending')
    VERIFIED = 'verified', _('Verified')
    REJECTED = 'rejected', _('Rejected')

        
BUSINESS_TYPE_CHOICES = [
    ('hotel', 'Hotel'),
    ('restaurant', 'Restaurant'),
    ('tour_operator', 'Tour Operator'),
    ('transportation', 'Transportation'),
    ('activity', 'Activity'),
    ('attraction', 'Attraction'),
    ('event', 'Event'),
    ('other', 'Other')
]
