# management/commands/setup_default_images.py
from django.core.management.base import BaseCommand
from django.core.files.base import ContentFile 
import os
from local_secrets.sites.models import DefaultImage

class Command(BaseCommand):
    help = 'Setup default images'

    def handle(self, *args, **kwargs):
        # Check existing
        existing = DefaultImage.objects.all()
        if existing.exists():
            self.stdout.write(self.style.WARNING('Default images already exist:'))
            for img in existing:
                self.stdout.write(f"- {img.type}: {img.image}")
            return

        # Create default profile image
        try:
            DefaultImage.objects.create(
                title='profile',
                image='defaults/default_profile.png'  # adjust path as needed
            )
            self.stdout.write(self.style.SUCCESS('Created default profile image'))
            
            # Add other default images if needed
            DefaultImage.objects.create(
                title='vendor',
                image='defaults/default_vendor.png'
            )
            self.stdout.write(self.style.SUCCESS('Created default vendor image'))
            
        except Exception as e:
            self.stdout.write(self.style.ERROR(f'Error creating default images: {e}'))
