# management/commands/setup_initial_data.py
from django.core.management.base import BaseCommand
from local_secrets.sites.models import DefaultImage
from django.core.files.base import ContentFile

class Command(BaseCommand):
    help = 'Setup initial data required for the application'

    def handle(self, *args, **kwargs):
        self.stdout.write('Setting up initial data...')

        # Create DefaultImage if it doesn't exist
        try:
            DefaultImage.objects.get(title='profile')
            self.stdout.write('Default profile image already exists')
        except DefaultImage.DoesNotExist:
            DefaultImage.objects.create(
                title='profile',
                image='defaults/default_profile.jpg'
            )
            self.stdout.write('Created default profile image')

        self.stdout.write(self.style.SUCCESS('Initial data setup complete'))
