import requests

# Your token from the previous response
ACCESS_TOKEN = "bbnrUhdaGEW5snk5iymCNUDSKsfMsS"
BASE_URL = "http://127.0.0.1:8000"

def register_as_vendor():
    headers = {
        "Authorization": f"Bearer {ACCESS_TOKEN}",
        "Content-Type": "application/json"
    }
    
    data = {
        "company_name": "Test Company LLC",
        "contact_email": "lsmanager1@example.com",
        "business_type": 1,
        "description": "Test company description",
        "short_description": "Short description",
        "tax_id": "123456789",
        "website": "https://testcompany.com",
        "contact_phone": "+1234567890",
        "founded_year": 2024,
        "facebook_url": "https://facebook.com/testcompany",
        "instagram_url": "https://instagram.com/testcompany",
        "twitter_url": "https://twitter.com/testcompany",
        "primary_address": "123 Test Street, Test City, 12345",
        "categories": [1],
        "cities": [1]
    }
    
    response = requests.post(
        f"{BASE_URL}/users/create/register_as_vendor",
        headers=headers,
        json=data
    )
    
    print("Vendor Registration Response:", response.json())
    return response.json()

def check_vendor_status():
    headers = {
        "Authorization": f"Bearer {ACCESS_TOKEN}"
    }
    
    response = requests.get(
        f"{BASE_URL}/users/vendors/vendor_status",
        headers=headers
    )
    
    print("Vendor Status:", response.json())
    return response.json()

def get_user_profile():
    headers = {
        "Authorization": f"Bearer {ACCESS_TOKEN}"
    }
    
    response = requests.get(
        f"{BASE_URL}/users/me",
        headers=headers
    )
    
    print("User Profile:", response.json())
    return response.json()

if __name__ == "__main__":
    # Register as vendor
    vendor_registration = register_as_vendor()
    
    # Check vendor status
    vendor_status = check_vendor_status()
    
    # Get user profile
    user_profile = get_user_profile()
