from django.urls import path, include
from rest_framework import routers
from . import views

router = routers.DefaultRouter(trailing_slash=False)

# User management
router.register(r'create', views.UserCreationViewSet, basename='CreateUser')
router.register(r'', views.UserViewSet, basename='Users')

# Tags
router.register(r'tags', views.TagViewSet, basename='Tags')

# Subscription related
router.register(r'subscription-plans', views.SubscriptionPlanViewSet, basename='subscription-plan')
router.register(r'subscriptions', views.VendorSubscriptionViewSet, basename='vendor-subscription')
router.register(r'subscription-management', views.SubscriptionManagementViewSet, basename='subscription-management')

# Site claims
router.register(r'site-claims', views.SiteClaimViewSet, basename='site-claim')

# Business categorization
router.register(r'business-categories', views.BusinessCategoryViewSet, basename='business-category')
router.register(r'business-types', views.BusinessTypeViewSet, basename='business-type')

# Vendor management
router.register(r'vendors', views.VendorViewSet, basename='vendor')
router.register(r'vendor-contacts', views.VendorContactViewSet, basename='vendor-contact')
router.register(r'vendor-reviews', views.VendorReviewViewSet, basename='vendor-review')

# Vendor registration and onboarding
router.register(r'vendor-registration', views.VendorRegistrationViewSet, basename='vendor-registration')
router.register(r'business-details', views.BusinessDetailsViewSet, basename='business-details')
router.register(r'document-verification', views.DocumentVerificationViewSet, basename='document-verification')
router.register(r'subscription-selection', views.SubscriptionSelectionViewSet, basename='subscription-selection')
router.register(r'account-activation', views.AccountActivationViewSet, basename='account-activation')
router.register(r'vendor-onboarding', views.VendorOnboardingViewSet, basename='vendor-onboarding')
  

# Analytics and reporting
router.register(r'analytics', views.AnalyticsViewSet, basename='analytics')
router.register(r'vendor-analytics', views.VendorAnalyticsViewSet, basename='vendor-analytics')
router.register(r'admin-dashboard', views.AdminDashboardViewSet, basename='admin-dashboard')

# Bulk operations
router.register(r'bulk-operations', views.BulkOperationsViewSet, basename='bulk-operations')

# Site management
router.register(r'site-management', views.SiteManagementViewSet, basename='site-management')

urlpatterns = [
    # Include router URLs
    path('', include(router.urls)),
    
    # Custom views
    path('vendor/profile/', views.VendorProfileUpdateView.as_view(), name='vendor_profile'),
    path('vendor/sites/', views.VendorSitesListView.as_view(), name='vendor_sites'),
    path('vendor/events/', views.VendorEventsListView.as_view(), name='vendor_events'),
    
    # Subscription webhooks and callbacks
    path('subscriptions/webhook/', views.SubscriptionWebhookView.as_view(), name='subscription_webhook'),
    path('subscriptions/callback/', views.SubscriptionCallbackView.as_view(), name='subscription_callback'),
    
    # Document upload endpoints
    path('documents/upload/', views.DocumentUploadView.as_view(), name='document_upload'),
    
    # Analytics export
    path('analytics/export/', views.AnalyticsExportView.as_view(), name='analytics_export'),
]
