from drf_yasg import openapi
from drf_yasg.generators import OpenAPISchemaGenerator
from drf_yasg.views import get_schema_view
from rest_framework import permissions


class CustomOpenAPISchemaGenerator(OpenAPISchemaGenerator):
    def get_endpoints(self, request):
        endpoints = super().get_endpoints(request)

        # Filter endpoints by the app name or URL prefix
        filtered_endpoints = {}
        for path, path_info in endpoints.items():

            # Check if the path starts with the prefix of the app
            if path.startswith("/api/custom-request/"):
                filtered_endpoints[path] = path_info

        return filtered_endpoints


# Create a schema view with the custom generator
schema_view = get_schema_view(
    openapi.Info(
        title="Local Secret - Service Integration API",
        default_version='v1',
        description="API documentation for the Service Integration app",
    ),
    public=True,
    permission_classes=(permissions.AllowAny,),
    generator_class=CustomOpenAPISchemaGenerator,
)
