from django.core.management.base import BaseCommand
from local_secrets.cities.models import City, Address
from django.db.models import Q
from utils.nominatim import Nominatim
from django.db import transaction
import asyncio
from local_secrets.cities.helpers.city_helper import DataMigration


class Command(BaseCommand):
    help = ""

    def handle(self, *args, **kwargs):

        geo_service = Nominatim()

        # List all cities which doesnot have continent or region or county assosiated.
        # cities = City.objects.filter(Q(continent__isnull=True) | Q(
        #     region__isnull=True) | Q(county__isnull=True)).order_by("-id")[:20]

        cities = City.objects.filter(
            continent__isnull=True, region__isnull=True, county__isnull=True
        ).order_by("-id")

        print("Processing... ")

        for city in cities:
            try:
                with transaction.atomic():
                    try:
                        lat = city.latitude
                        lon = city.longitude

                        task = geo_service.get_location_data(lat, lon)
                        city_data = asyncio.run(task)

                        print(f'Started Processing city id: {city.id}')

                        city_sync = DataMigration(
                            address_info=city_data, country=city.country)
                        city_sync.sync_region_and_county()

                        city = City.objects.get(id=city.id)

                        if hasattr(city_sync, "region_obj"):
                            city.region = getattr(
                                city_sync, "region_obj", None)

                        if hasattr(city_sync, "county_obj"):
                            city.county = getattr(
                                city_sync, "county_obj", None)

                        if city.country.continent:
                            city.continent = city.country.continent

                        city.save()

                    except Exception as e:
                        print(f"City save failed: {str(e)}")
                        continue

                    print(f'Completed Processing city id: {city.id}')

            except Exception as e:
                print("City exception !!!")
                print(str(e))

        print("City Processed successfully... ")
        print(".............................. ")
        print()

        print("Processing Neighbours......... ")

        with transaction.atomic():

            unique_locations = (
                Address.objects.filter(neighborhood__isnull=True).
                values("latitude", "longitude", "city").
                distinct()
                .iterator()
            )

            print("Processing Neighbours by city, latitude and longitude......... ")

            for location in unique_locations:
                try:
                    lat, lon = location["latitude"], location["longitude"]

                    task = geo_service.get_location_data(lat, lon)
                    address_data = asyncio.run(task)

                    city = City.objects.filter(id=location["city"]).last()

                    address_sync = DataMigration(
                        address_info=address_data, city=city)
                    address_sync.sync_neighbour()

                    if hasattr(address_sync, "neighbour_obj"):
                        neighbour = getattr(
                            address_sync, "neighbour_obj", None)
                        Address.objects.filter(
                            city=city.id, latitude=lat, longitude=lon).update(
                            neighborhood=neighbour.id)

                except Exception as e:
                    print(f"Address save failed: {str(e)}")
                    continue

            print("Processed Neighbours......... ")

        self.stdout.write(self.style.SUCCESS(
            "Data populated executed successfully!"))
