# Generated by Django 3.2.25 on 2025-03-14 10:10

import django.contrib.gis.db.models.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('cities', '0028_city_activated'),
    ]

    operations = [
        migrations.CreateModel(
            name='Continent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Continent Name')),
                ('code', models.CharField(max_length=2, unique=True, verbose_name='ISO Code')),
            ],
            options={
                'verbose_name': 'Continent',
                'verbose_name_plural': 'Continents',
            },
        ),
        migrations.AlterModelOptions(
            name='cityimage',
            options={'verbose_name': 'City Image', 'verbose_name_plural': 'City Images'},
        ),
        migrations.AlterField(
            model_name='city',
            name='activated',
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name='city',
            name='latitude',
            field=models.DecimalField(decimal_places=27, default=0, max_digits=30, verbose_name='Latitude'),
        ),
        migrations.AlterField(
            model_name='city',
            name='longitude',
            field=models.DecimalField(decimal_places=27, default=0, max_digits=30, verbose_name='Longitude'),
        ),
        migrations.AlterField(
            model_name='city',
            name='point',
            field=django.contrib.gis.db.models.fields.PointField(blank=True, null=True, srid=4326, verbose_name='Geolocation'),
        ),
        migrations.AlterField(
            model_name='country',
            name='code',
            field=models.CharField(max_length=3, verbose_name='ISO Code'),
        ),
        migrations.AlterField(
            model_name='country',
            name='phone_code',
            field=models.CharField(default='34', max_length=10, verbose_name='Phone Code'),
        ),
        migrations.AlterField(
            model_name='translatedcity',
            name='language',
            field=models.CharField(max_length=10, verbose_name='Language'),
        ),
        migrations.AlterField(
            model_name='translatedcity',
            name='name',
            field=models.CharField(max_length=500, verbose_name='Translated City Name'),
        ),
        migrations.AlterField(
            model_name='translatedcountry',
            name='language',
            field=models.CharField(max_length=10, verbose_name='Language'),
        ),
        migrations.AlterField(
            model_name='translatedcountry',
            name='name',
            field=models.CharField(max_length=500, verbose_name='Translated Country Name'),
        ),
        migrations.AlterUniqueTogether(
            name='translatedcity',
            unique_together={('city', 'language')},
        ),
        migrations.AlterUniqueTogether(
            name='translatedcountry',
            unique_together={('country', 'language')},
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Region/State Name')),
                ('country', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='regions', to='cities.country')),
            ],
            options={
                'verbose_name': 'Region',
                'verbose_name_plural': 'Regions',
            },
        ),
        migrations.CreateModel(
            name='Neighborhood',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Neighborhood Name')),
                ('city', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='neighborhoods', to='cities.city')),
            ],
            options={
                'verbose_name': 'Neighborhood',
                'verbose_name_plural': 'Neighborhoods',
            },
        ),
        migrations.CreateModel(
            name='County',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='County/District Name')),
                ('region', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='counties', to='cities.region')),
            ],
            options={
                'verbose_name': 'County',
                'verbose_name_plural': 'Counties',
            },
        ),
        migrations.CreateModel(
            name='TranslatedRegion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=10, verbose_name='Language')),
                ('name', models.CharField(max_length=255, verbose_name='Translated Region Name')),
                ('region', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='cities.region')),
            ],
            options={
                'unique_together': {('region', 'language')},
            },
        ),
        migrations.CreateModel(
            name='TranslatedNeighborhood',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=10, verbose_name='Language')),
                ('name', models.CharField(max_length=255, verbose_name='Translated Neighborhood Name')),
                ('neighborhood', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='cities.neighborhood')),
            ],
            options={
                'unique_together': {('neighborhood', 'language')},
            },
        ),
        migrations.CreateModel(
            name='TranslatedCounty',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=10, verbose_name='Language')),
                ('name', models.CharField(max_length=255, verbose_name='Translated County Name')),
                ('county', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='cities.county')),
            ],
            options={
                'unique_together': {('county', 'language')},
            },
        ),
        migrations.CreateModel(
            name='TranslatedContinent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=10, verbose_name='Language')),
                ('name', models.CharField(max_length=255, verbose_name='Translated Continent Name')),
                ('continent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='cities.continent')),
            ],
            options={
                'unique_together': {('continent', 'language')},
            },
        ),
    ]
