# management/commands/create_default_groups.py
from django.core.management.base import BaseCommand
from django.contrib.auth.models import Group, Permission
from django.contrib.contenttypes.models import ContentType

class Command(BaseCommand):
    help = 'Create default groups and permissions'

    def create_or_verify_group(self, group_name):
        group, created = Group.objects.get_or_create(name=group_name)
        if created:
            self.stdout.write(self.style.SUCCESS(f'Successfully created {group_name} group'))
        else:
            self.stdout.write(self.style.WARNING(f'{group_name} group already exists'))

    def handle(self, *args, **kwargs):
        # Show existing groups first
        existing_groups = Group.objects.all()
        self.stdout.write("Existing groups before creation:")
        for group in existing_groups:
            self.stdout.write(f"- {group.name}")

        # Create or verify groups
        self.create_or_verify_group('Viajero')
        self.create_or_verify_group('Vendor')
        self.create_or_verify_group('Admin')

        # Show final groups
        final_groups = Group.objects.all()
        self.stdout.write("\nFinal groups after creation:")
        for group in final_groups:
            self.stdout.write(f"- {group.name}")
