from django.http import FileResponse, HttpResponse
from django.template.loader import get_template
from django.utils import translation
from rest_framework import viewsets
from rest_framework.decorators import action
from rest_framework.exceptions import AuthenticationFailed
from rest_framework.permissions import AllowAny
from rest_framework_social_oauth2.views import TokenView
from django.utils.translation import gettext_lazy as _
from rest_framework.exceptions import ValidationError

from local_secrets.operations.models import PrivacyPolicies
from local_secrets.users.models import CustomUser
from local_secrets.service_integration.client import ResourceVerifySignature
import requests
from django.http import JsonResponse
from django.conf import settings
from django.views.decorators.csrf import csrf_exempt
from django.views import View
import json

MAILGUN_API_BASE_URL = "https://api.mailgun.net/v3"
MAILGUN_API_KEY = "d1c6e91788fa6ec90d2aa40d66cb7399-7c5e3295-3f23d588" #settings.MAILGUN_API_KEY  # Add this in your settings
MAILGUN_LIST_ADDRESS = "info@localsecrets.travel"
MAILGUN_DOMAIN = "localsecrets.travel"
CONTACT_EMAIL_RECIPIENT = "info@localsecrets.travel"

class CustomTokenView(TokenView):
    def post(self, request, *args, **kwargs): 
        if request.data['grant_type'] == "client_credentials":
            if 'X-Signature' in request.headers and 'X-Timestamp' in request.headers:
                signature = request.headers['X-Signature']
                timestamp = request.headers['X-Timestamp']

                is_valid_sign = ResourceVerifySignature().validate_signature("token", timestamp, signature)
                if not is_valid_sign:
                   raise AuthenticationFailed(detail=_("Invalid Signature"))
            else:
                raise AuthenticationFailed("If the grant type is client_credentials," 
                                           "the request must include a valid signature and a timestamp "
                                           "to ensure the URL's authenticity and prevent replay attacks.")
        else:
            request.data['password'] = request.data['password'].rstrip()
            if 'email' in request.data:
                try:
                    user = CustomUser.objects.get(email=request.data.get('email').rstrip())
                    request.data['username'] = user.username
                    if not user.is_active:
                        raise ValidationError({
                            'detail': "You need to verify your email address before accessing your account.",
                            'code': "account_inactive"
                        })
                except CustomUser.DoesNotExist:
                        raise AuthenticationFailed(detail=_('We couldn’t find an account with that email address.'))

        response = super().post(request, *args, **kwargs)

        return response


class PoliciesViewSet(viewsets.ViewSet):
    @action(detail=False, methods=['get'], permission_classes=(AllowAny,))
    def terms_and_conditions(self, request):
        # filename = 'static/terms_and_conditions.pdf'
        filename = PrivacyPolicies.objects.get(title='terms_and_conditions').file
        if not request.user.is_anonymous:
            if request.user.language and request.user.language.code.lower() != 'es':
                # filename = 'static/en_terms_and_conditions.pdf'
                filename = PrivacyPolicies.objects.get(title='en_terms_and_conditions').file
        return FileResponse(filename, content_type='application/pdf')

    @action(detail=False, methods=['get'], permission_classes=(AllowAny,), url_path='es/privacy_policies')
    def privacy_policies_es(self, request):
        # filename = 'static/privacy_policies.pdf'
        # filename = PrivacyPolicies.objects.get(title='privacy_policies').file.url
        # if not request.user.is_anonymous:
        #     if request.user.language and request.user.language.code.lower() != 'es':
        #         # filename = 'static/en_privacy_policies.pdf'
        #         filename = PrivacyPolicies.objects.get(title='en_privacy_policies').file.url
        context = {}

        template_path = 'info/policies_info.html'
        template = get_template(template_path)
        html = template.render(context)
        return HttpResponse(html)

        # return FileResponse(filename, content_type='application/pdf')

    @action(detail=False, methods=['get'], permission_classes=(AllowAny,), url_path='en/privacy_policies')
    def privacy_policies_en(self, request):
        context = {}

        template_path = 'info/en_policies_info.html'
        template = get_template(template_path)
        html = template.render(context)
        return HttpResponse(html)


class InfoViewSet(viewsets.ViewSet):
    permission_classes = (AllowAny,)

    @action(
        detail=False,
        methods=['get'],
    )
    def deletion(self, request, *args, **kwargs):
        context = {}
        template_path = 'info/deletion_info.html'
        template = get_template(template_path)
        html = template.render(context)

        return HttpResponse(html)
 


class SubscribeView(View):
    """
    View to subscribe a user to the Mailgun mailing list.
    """
    @csrf_exempt
    def post(self, request, *args, **kwargs):
        try:
            data = json.loads(request.body)
            email = data.get('email')
            if not email:
                return JsonResponse({"error": "Email is required"}, status=400)

            response = requests.post(
                f"{MAILGUN_API_BASE_URL}/lists/{MAILGUN_LIST_ADDRESS}/members",
                auth=("api", MAILGUN_API_KEY),
                data={"subscribed": True, "address": email}
            )
            if response.status_code != 200:
                return JsonResponse({"error": "Failed to subscribe user"}, status=500)

            return JsonResponse({"message": "User subscribed successfully"}, status=200)

        except Exception as e:
            return JsonResponse({"error": str(e)}, status=500)
 
class ContactFormView(View):
    """
    View to handle contact form submissions.
    """
    @csrf_exempt
    def post(self, request, *args, **kwargs):
        try:
            # Parse request data
            data = json.loads(request.body)
            first_name = data.get('first_name')
            last_name = data.get('last_name')
            linkedin = data.get('linkedin')
            email = data.get('email')
            message = data.get('message')

            # Validate required fields
            if not (first_name and last_name and linkedin and email and message):
                return JsonResponse({"error": "All fields are required"}, status=400)

            # Send email to the admin or store in the database
            response = requests.post(
                f"{MAILGUN_API_BASE_URL}/{MAILGUN_DOMAIN}/messages",
                auth=("api", MAILGUN_API_KEY),
                data={
                    "from": f"{first_name} {last_name} <noreply@{MAILGUN_DOMAIN}>",
                    "to": [CONTACT_EMAIL_RECIPIENT],
                    "subject": "New Contact Form Submission",
                    "text": f"""
                    Name: {first_name} {last_name}
                    LinkedIn: {linkedin}
                    Email: {email}
                    Message: {message}
                    """
                }
            )

            if response.status_code != 200:
                return JsonResponse({"error": "Failed to send the message"}, status=500)

            return JsonResponse({"message": "Your message has been sent successfully"}, status=200)

        except Exception as e:
            return JsonResponse({"error": str(e)}, status=500)