# local_secrets/payment/notifications.py

from django.conf import settings
from django.urls import reverse
from django.utils.translation import gettext as _
from django.utils.translation import gettext_lazy as _
from django.core.mail import send_mail
from django.template.loader import render_to_string
from django.utils.html import strip_tags
from django.db import transaction
from django.db.models import Q
from django.core.cache import cache
from django.utils import timezone
from typing import Dict, Any, Optional
from decimal import Decimal
from local_secrets.users.models import Vendor
from local_secrets.payment.models import VendorPayment, PaymentMethod
from local_secrets.payment.exceptions import PaymentError 
from local_secrets.payment.utility import get_payment_url, get_payment_status_url, send_payment_notification, clear_payment_cache, get_payment_cache
 
class PaymentNotificationService:
    """Service to handle payment notifications and callbacks"""

    def __init__(self):
        self.cache_timeout = 300  # 5 minutes

    def process_notification(self, data: Dict[str, Any]) -> None:
        """Process incoming payment notification"""
        payment_id = data.get('payment_id')
        payment = get_payment_cache(payment_id)
        if not payment:
            raise PaymentError(_("Payment not found"))

        with transaction.atomic():
            payment.status = 'completed'
            payment.save()
            clear_payment_cache(payment_id)

        send_payment_notification(payment, success=True)
        self._log_notification(payment, data)
