# local_secrets/payment/permissions.py

from rest_framework import permissions

class IsVendorOwner(permissions.BasePermission):
    """
    Custom permission to only allow owners of a payment to view it
    """
    def has_object_permission(self, request, view, obj):
        return obj.vendor == request.user.vendor_profile
