# local_secrets/payment/signals.py

from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import PaymentMethod

@receiver(post_save, sender=PaymentMethod)
def initialize_syspay_payment_method(sender, instance, created, **kwargs):
    """Initialize SysPay payment method when created"""
    if created and instance.payment_type == 'syspay':
        instance.initialize_syspay()
        instance.save()