# local_secrets/payment/tests/test_syspay_webhooks.py

import pytest
import hmac
import hashlib
import json
from django.utils import timezone
from django.urls import reverse

class TestSysPayWebhooks:
    @pytest.fixture
    def webhook_headers(self, syspay_test_config):
        timestamp = str(int(timezone.now().timestamp()))
        return {
            'X-Timestamp': timestamp,
            'X-Partner-ID': syspay_test_config['PARTNER_ID']
        }

    def test_payment_success_webhook(self, client, webhook_headers):
        payload = {
            'event_type': 'payment.succeeded',
            'payment_id': 'test_payment_123',
            'amount': 1000,
            'currency': 'EUR',
            'status': 'completed'
        }
        
        response = client.post(
            reverse('syspay-webhook'),
            data=json.dumps(payload),
            content_type='application/json',
            **webhook_headers
        )
        
        assert response.status_code == 200

    def test_payment_failed_webhook(self, client, webhook_headers):
        payload = {
            'event_type': 'payment.failed',
            'payment_id': 'test_payment_456',
            'error_code': 'card_declined',
            'error_message': 'The card was declined'
        }
        
        response = client.post(
            reverse('syspay-webhook'),
            data=json.dumps(payload),
            content_type='application/json',
            **webhook_headers
        )
        
        assert response.status_code == 200
