"""Custom request call"""
import hashlib
import hmac
from config.settings import base as settings


class ResourceVerifySignature:
    """
    Class for verifying access signatures for resource requests.
    """
    __secret_key = None
    __namespace = "localsecret"

    def __init__(self):
        self.__secret_key = settings.SIGATURE_SECRET

    def validate_signature(
            self, topic, timestamp, client_signature):
        """
        Validate the provided signature against the server-generated signature.
        """
        signature_data = f"REQUEST::{self.__namespace}::{topic}::POST::{str(timestamp)}"
        server_signature = hmac.new(
            self.__secret_key.encode(),
            signature_data.encode(),
            hashlib.sha256).hexdigest()
        return client_signature == server_signature
