from django.apps import AppConfig
from django.utils.translation import gettext_lazy as _
 


class SitesConfig(AppConfig):
    default_auto_field = 'django.db.models.BigAutoField'
    name = 'local_secrets.sites'
    verbose_name = _('Sites')


    def ready(self):
        import local_secrets.sites.signals
        self.modify_admin_site()


    def modify_admin_site(self):
        from local_secrets.core.admin import admin_site
        
        # Store original method
        original_get_app_list = admin_site.get_app_list
        
        def get_app_list(request):
            app_list = original_get_app_list(request)
            
            if request.user.is_staff:
                # Find the Sites app
                sites_app = next(
                    (app for app in app_list if app['app_label'] == 'sites'),
                    None
                ) 
            return app_list
        
        # Replace the method
        admin_site.get_app_list = get_app_list
