from django.db import models
from django.utils.translation import gettext_lazy as _

class SiteType(models.TextChoices):
    PLACE = 'place', 'Place'
    EVENT = 'event', 'Event'


class SitesSubscriptionType(models.TextChoices):
    FREE = 'free', _('Free')
    BASIC = 'basic', _('Basic')
    PREMIUM = 'premium', _('Premium')
    ENTERPRISE = 'enterprise', _('Enterprise')
 

class Day(models.TextChoices):
    MONDAY = 'monday', _('Monday')
    TUESDAY = 'tuesday', _('Tuesday')
    WEDNESDAY = 'wednesday', _('Wednesday')
    THURSDAY = 'thursday', _('Thursday')
    FRIDAY = 'friday', _('Friday')
    SATURDAY = 'saturday', _('Saturday')
    SUNDAY = 'sunday', _('Sunday')


class FrequencyChoices(models.TextChoices):
    NEVER = 'never', 'Does not repeat (Uses schedules)'
    DAY = 'day', 'Every day'
    WEEK = 'week', 'Every week'
    # MONTH = 'month', 'Every month'
    YEAR = 'year', 'Every year'
    WORKDAY = 'workday', 'Every working day'

class SiteStatusChoices(models.TextChoices):
    DRAFT = 'draft', _('Draft')
    PENDING_REVIEW = 'pending_review', _('Pending Review')
    REJECTED = 'rejected', _('Rejected')
    APPROVED = 'approved', _('Approved')
    PUBLISHED = 'published', _('Published')
    UNPUBLISHED = 'unpublished', _('Unpublished')
    SUSPENDED = 'suspended', _('Suspended')

class SiteVisibilityChoices(models.TextChoices):
    VISIBLE = 'visible', _('Visible')
    HIDDEN = 'hidden', _('Hidden')
    SUBSCRIPTION_EXPIRED = 'subscription_expired', _('Subscription Expired')
    PAYMENT_PENDING = 'payment_pending', _('Payment Pending')

class SiteSubscriptionStatus(models.TextChoices):
    FREE = 'free', _('Free')
    TRIAL = 'trial', _('Trial')
    ACTIVE = 'active', _('Active')
    EXPIRED = 'expired', _('Expired')
    CANCELLED = 'cancelled', _('Cancelled')