# sites/forms.py
from django import forms
from .models import ReviewChecklistItem, Site, SiteReview, ReviewChecklistResponse 

class SiteReviewForm(forms.ModelForm):
    class Meta:
        model = SiteReview
        fields = ['status', 'feedback']
        
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        if self.instance:
            self.fields['checklist_responses'] = forms.ModelMultipleChoiceField(
                queryset=ReviewChecklistItem.objects.all(),
                widget=forms.CheckboxSelectMultiple,
                required=False
            )
            
    def save(self, commit=True):
        review = super().save(commit=False)
        if commit:
            review.save()
            # Save checklist responses
            for item in self.cleaned_data['checklist_responses']:
                ReviewChecklistResponse.objects.create(
                    review=review,
                    checklist_item=item,
                    is_satisfied=True
                )
        return review

