# local_secrets/sites/tests/test_integration.py

from datetime import timedelta, timezone
from unittest import TestCase
from local_secrets.payment.models import VendorPayment
from local_secrets.sites.choices import SiteVisibilityChoices
from local_secrets.sites.cron import VisibilityCronJob
from local_secrets.sites.models import Site
from local_secrets.users.models import Vendor, VendorSubscription


class VisibilityIntegrationTests(TestCase):
    def setUp(self):
        self.vendor = Vendor.objects.create(name="Test Vendor")
        self.subscription = VendorSubscription.objects.create(
        vendor=self.vendor,
        status='active',
        end_date=timezone.now() + timedelta(days=30)
        )
        self.site = Site.objects.create(
        vendor=self.vendor,
        visibility=SiteVisibilityChoices.VISIBLE
        )
    def test_payment_visibility_flow(self):
        # Create payment
        payment = VendorPayment.objects.create(
            vendor=self.vendor,
            status='pending',
            amount=100
        )
        
        # Check visibility updated to pending
        self.site.refresh_from_db()
        self.assertEqual(
            self.site.visibility,
            SiteVisibilityChoices.PAYMENT_PENDING
        )
        
        # Process payment
        payment.status = 'processed'
        payment.save()
        
        # Check visibility restored
        self.site.refresh_from_db()
        self.assertEqual(
            self.site.visibility,
            SiteVisibilityChoices.VISIBLE
        )


    def test_subscription_expiration_flow(self):
        # Expire subscription
        self.subscription.end_date = timezone.now() - timedelta(days=1)
        self.subscription.save()
        
        # Run cron job
        cron = VisibilityCronJob()
        cron.process_pending_visibility_updates()
        
        # Check visibility updated
        self.site.refresh_from_db()
        self.assertEqual(
            self.site.visibility,
            SiteVisibilityChoices.SUBSCRIPTION_EXPIRED
        )


