class SiteService {
    static async recordView(siteId) {
        const cacheKey = `site_view_${siteId}_${this.getCurrentHour()}`;
        
        // Check if recently viewed
        if (!localStorage.getItem(cacheKey)) {
            try {
                await axios.post(`/sites/${siteId}/record_view/`);
                
                // Set local storage to prevent duplicate counts
                localStorage.setItem(cacheKey, 'true');
                
                // Remove after 1 hour
                setTimeout(() => {
                    localStorage.removeItem(cacheKey);
                }, 3600000);
                
            } catch (error) {
                console.error('Error recording view:', error);
            }
        }
    }


    static getCurrentHour() {
        const now = new Date();
        return `${now.getFullYear()}${now.getMonth()}${now.getDate()}${now.getHours()}`;
    }
}


// Usage in components
async function viewSite(siteId) {
    await SiteService.recordView(siteId);
}
