# local_secrets/sites/views/analytics.py

from django.views.generic import TemplateView
from django.contrib.auth.mixins import UserPassesTestMixin
from ..analytics import SiteAnalytics

class AnalyticsDashboardView(UserPassesTestMixin, TemplateView):
    template_name = 'sites/admin/analytics_dashboard.html'
    
    def test_func(self):
        return self.request.user.is_staff
    
    def get_context_data(self, **kwargs):
        context = super().get_context_data(**kwargs)
        
        # Get date range from request or default to 30 days
        date_range = int(self.request.GET.get('date_range', 30))
        analytics = SiteAnalytics(date_range=date_range)
        
        context.update({
            'review_metrics': analytics.get_review_metrics(),
            'subscription_metrics': analytics.get_subscription_metrics(),
            'date_range': date_range,
            'date_range_options': [7, 30, 90, 180, 365]
        })
        
        return context
