# exceptions.py
from rest_framework.exceptions import APIException
from rest_framework import status

class VendorRegistrationError(APIException):
    status_code = status.HTTP_400_BAD_REQUEST
    default_detail = 'Failed to complete vendor registration.'
    default_code = 'vendor_registration_error'

class DocumentUploadError(APIException):
    status_code = status.HTTP_400_BAD_REQUEST
    default_detail = 'Failed to upload verification documents.'
    default_code = 'document_upload_error'

class SubscriptionError(APIException):
    status_code = status.HTTP_400_BAD_REQUEST
    default_detail = 'Failed to process subscription.'
    default_code = 'subscription_error'
 