# local_secrets/users/management/commands/cleanup_pending_claims.py

from datetime import timedelta
from django.core.management.base import BaseCommand
from django.utils import timezone
from local_secrets.users.models import SiteClaim

class Command(BaseCommand):
    help = 'Clean up old pending site claims'

    def add_arguments(self, parser):
        parser.add_argument(
            '--days',
            type=int,
            default=30,
            help='Age in days of claims to clean up'
        )

    def handle(self, *args, **options):
        days_threshold = options['days']
        cutoff_date = timezone.now() - timedelta(days=days_threshold)
        
        # Get old pending claims
        old_claims = SiteClaim.objects.filter(
            status='PENDING',
            created_at__lt=cutoff_date
        )
        
        count = old_claims.count()
        old_claims.update(
            status='REJECTED',
            notes='Automatically rejected due to inactivity'
        )
        
        self.stdout.write(
            self.style.SUCCESS(
                f'Cleaned up {count} old pending claims'
            )
        )
