# management/commands/setup_review_groups.py
from django.core.management.base import BaseCommand
from django.contrib.auth.models import Group, Permission
from django.contrib.contenttypes.models import ContentType

from local_secrets.sites.models import SiteReview
 

class Command(BaseCommand):
    help = 'Creates necessary groups and permissions for site review system'

    def handle(self, *args, **options):
        # Create Ambassadors group
        ambassadors_group, created = Group.objects.get_or_create(name='Ambassadors')
        
        # Get content type for SiteReview
        review_content_type = ContentType.objects.get_for_model(SiteReview)
        
        # Define permissions for Ambassadors
        permissions = Permission.objects.filter(
            content_type=review_content_type,
            codename__in=['view_sitereview', 'change_sitereview']
        )
        
        # Assign permissions to group
        ambassadors_group.permissions.set(permissions)
        
        self.stdout.write(self.style.SUCCESS('Successfully set up review groups'))
