# Generated by Django 3.2.25 on 2025-04-03 07:27

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0004_site_is_vendor_featured'),
        ('cities', '0003_auto_20250324_1424'),
        ('languages', '0001_initial'),
        ('users', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='SubscriptionPlan',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('type', models.CharField(choices=[('free', 'Free'), ('basic', 'Basic'), ('premium', 'Premium'), ('enterprise', 'Enterprise')], max_length=20)),
                ('price', models.DecimalField(decimal_places=2, max_digits=10)),
                ('billing_period', models.CharField(choices=[('monthly', 'Monthly'), ('yearly', 'Yearly'), ('custom', 'Custom')], default='monthly', max_length=20)),
                ('duration_days', models.PositiveIntegerField(blank=True, null=True)),
                ('max_sites', models.IntegerField()),
                ('max_events', models.IntegerField()),
                ('features', models.JSONField(default=dict)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Subscription Plan',
                'verbose_name_plural': 'Subscription Plans',
                'ordering': ['price', 'name'],
            },
        ),
        migrations.CreateModel(
            name='Vendor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('company_name', models.CharField(max_length=255, verbose_name='Company Name')),
                ('slug', models.SlugField(max_length=255, unique=True, verbose_name='URL Slug')),
                ('business_type', models.CharField(max_length=100, verbose_name='Business Type')),
                ('tax_id', models.CharField(blank=True, max_length=50, null=True, verbose_name='Tax ID')),
                ('website', models.URLField(blank=True, null=True, verbose_name='Website')),
                ('description', models.TextField(blank=True, verbose_name='Business Description')),
                ('short_description', models.CharField(blank=True, max_length=280, verbose_name='Short Description')),
                ('founded_year', models.PositiveIntegerField(blank=True, null=True, verbose_name='Year Founded')),
                ('verification_status', models.CharField(choices=[('pending', 'Pending'), ('verified', 'Verified'), ('rejected', 'Rejected')], default='pending', max_length=20, verbose_name='Verification Status')),
                ('verified_at', models.DateTimeField(blank=True, null=True, verbose_name='Verification Date')),
                ('subscription_type', models.CharField(choices=[('free', 'Free'), ('basic', 'Basic'), ('premium', 'Premium'), ('enterprise', 'Enterprise')], default='free', max_length=20, verbose_name='Subscription Type')),
                ('subscription_expires', models.DateTimeField(blank=True, null=True, verbose_name='Subscription Expiry Date')),
                ('contact_email', models.EmailField(max_length=254, verbose_name='Contact Email')),
                ('contact_phone', models.CharField(blank=True, max_length=50, verbose_name='Contact Phone')),
                ('facebook_url', models.URLField(blank=True, null=True, verbose_name='Facebook URL')),
                ('instagram_url', models.URLField(blank=True, null=True, verbose_name='Instagram URL')),
                ('twitter_url', models.URLField(blank=True, null=True, verbose_name='Twitter URL')),
                ('logo', models.ImageField(blank=True, null=True, upload_to='vendor_logos', verbose_name='Logo')),
                ('header_image', models.ImageField(blank=True, null=True, upload_to='vendor_headers', verbose_name='Header Image')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
                ('is_featured', models.BooleanField(default=False, verbose_name='Featured Vendor')),
                ('categories', models.ManyToManyField(related_name='vendors', to='sites.Category', verbose_name='Service Categories')),
                ('cities', models.ManyToManyField(related_name='vendors', to='cities.City', verbose_name='Operating Cities')),
                ('primary_address', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='primary_for_vendors', to='cities.address', verbose_name='Primary Address')),
                ('tags', models.ManyToManyField(related_name='vendor_tags', to='users.Tag', verbose_name='Tags')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='vendor_profile', to=settings.AUTH_USER_MODEL, verbose_name='User Account')),
            ],
            options={
                'verbose_name': 'Vendor',
                'verbose_name_plural': 'Vendors',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='VendorSubscription',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.DateTimeField()),
                ('end_date', models.DateTimeField()),
                ('status', models.CharField(choices=[('active', 'Active'), ('cancelled', 'Cancelled'), ('expired', 'Expired'), ('pending', 'Pending')], default='pending', max_length=20)),
                ('payment_status', models.CharField(choices=[('pending', 'Pending'), ('completed', 'Completed'), ('failed', 'Failed'), ('refunded', 'Refunded')], default='pending', max_length=20)),
                ('payment_id', models.CharField(blank=True, max_length=255)),
                ('sites_quota_used', models.IntegerField(default=0)),
                ('events_quota_used', models.IntegerField(default=0)),
                ('auto_renew', models.BooleanField(default=True)),
                ('cancelled_at', models.DateTimeField(blank=True, null=True)),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='users.subscriptionplan')),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Vendor Subscription',
                'verbose_name_plural': 'Vendor Subscriptions',
                'ordering': ['-start_date'],
            },
        ),
        migrations.CreateModel(
            name='VendorOpeningHours',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('day_of_week', models.PositiveSmallIntegerField(verbose_name='Day of Week')),
                ('from_hour', models.TimeField(verbose_name='From Hour')),
                ('to_hour', models.TimeField(verbose_name='To Hour')),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='opening_hours', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Vendor Opening Hours',
                'verbose_name_plural': 'Vendor Opening Hours',
                'ordering': ['day_of_week', 'from_hour'],
            },
        ),
        migrations.CreateModel(
            name='VendorDocument',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Document Name')),
                ('file', models.FileField(upload_to='vendor_documents', verbose_name='Document File')),
                ('document_type', models.CharField(max_length=100, verbose_name='Document Type')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
                ('verified', models.BooleanField(default=False)),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='documents', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Vendor Document',
                'verbose_name_plural': 'Vendor Documents',
            },
        ),
        migrations.CreateModel(
            name='VendorContact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Contact Name')),
                ('position', models.CharField(blank=True, max_length=100, verbose_name='Position')),
                ('email', models.EmailField(max_length=254, verbose_name='Email')),
                ('phone', models.CharField(blank=True, max_length=50, verbose_name='Phone')),
                ('is_primary', models.BooleanField(default=False, verbose_name='Primary Contact')),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='contacts', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Vendor Contact',
                'verbose_name_plural': 'Vendor Contacts',
            },
        ),
        migrations.CreateModel(
            name='TranslatedVendorInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('company_name', models.CharField(max_length=255, verbose_name='Translated Company Name')),
                ('description', models.TextField(verbose_name='Translated Business Description')),
                ('short_description', models.CharField(blank=True, max_length=280, verbose_name='Translated Short Description')),
                ('language', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='languages.language')),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Translated Vendor Information',
                'verbose_name_plural': 'Translated Vendor Information',
            },
        ),
        migrations.CreateModel(
            name='SubscriptionUsageReport',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('report_date', models.DateField()),
                ('sites_count', models.IntegerField()),
                ('sites_quota_percentage', models.DecimalField(decimal_places=2, max_digits=5)),
                ('events_count', models.IntegerField()),
                ('events_quota_percentage', models.DecimalField(decimal_places=2, max_digits=5)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('subscription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='usage_reports', to='users.vendorsubscription')),
            ],
            options={
                'verbose_name': 'Subscription Usage Report',
                'verbose_name_plural': 'Subscription Usage Reports',
                'ordering': ['-report_date'],
            },
        ),
        migrations.CreateModel(
            name='SubscriptionTransaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('transaction_id', models.CharField(max_length=255)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('completed', 'Completed'), ('failed', 'Failed'), ('refunded', 'Refunded')], max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('subscription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transactions', to='users.vendorsubscription')),
            ],
            options={
                'verbose_name': 'Subscription Transaction',
                'verbose_name_plural': 'Subscription Transactions',
            },
        ),
        migrations.CreateModel(
            name='SubscriptionAuditLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(choices=[('created', 'Created'), ('renewed', 'Renewed'), ('upgraded', 'Upgraded'), ('downgraded', 'Downgraded'), ('cancelled', 'Cancelled'), ('expired', 'Expired'), ('payment_failed', 'Payment Failed')], max_length=20)),
                ('details', models.JSONField(default=dict)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('new_plan', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='users.subscriptionplan')),
                ('old_plan', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='users.subscriptionplan')),
                ('subscription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='audit_logs', to='users.vendorsubscription')),
            ],
            options={
                'verbose_name': 'Subscription Audit Log',
                'verbose_name_plural': 'Subscription Audit Logs',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='SiteClaim',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('PENDING', 'Pending'), ('APPROVED', 'Approved'), ('REJECTED', 'Rejected')], default='PENDING', max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('processed_at', models.DateTimeField(blank=True, null=True)),
                ('notes', models.TextField(blank=True)),
                ('processed_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='processed_claims', to=settings.AUTH_USER_MODEL)),
                ('proof_documents', models.ManyToManyField(related_name='claims', to='users.VendorDocument')),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='claims', to='sites.site')),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='site_claims', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Site Claim',
                'verbose_name_plural': 'Site Claims',
            },
        ),
        migrations.CreateModel(
            name='VendorReview',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rating', models.PositiveSmallIntegerField(verbose_name='Rating')),
                ('title', models.CharField(blank=True, max_length=255, verbose_name='Review Title')),
                ('comment', models.TextField(verbose_name='Review Comment')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vendor_reviews', to=settings.AUTH_USER_MODEL)),
                ('vendor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='reviews', to='users.vendor')),
            ],
            options={
                'verbose_name': 'Vendor Review',
                'verbose_name_plural': 'Vendor Reviews',
                'unique_together': {('vendor', 'user')},
            },
        ),
        migrations.AddIndex(
            model_name='vendor',
            index=models.Index(fields=['company_name'], name='users_vendo_company_82c21c_idx'),
        ),
        migrations.AddIndex(
            model_name='vendor',
            index=models.Index(fields=['verification_status'], name='users_vendo_verific_0c890e_idx'),
        ),
        migrations.AddIndex(
            model_name='vendor',
            index=models.Index(fields=['is_featured'], name='users_vendo_is_feat_b397cf_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='translatedvendorinfo',
            unique_together={('vendor', 'language')},
        ),
        migrations.AlterUniqueTogether(
            name='subscriptionusagereport',
            unique_together={('subscription', 'report_date')},
        ),
        migrations.AlterUniqueTogether(
            name='siteclaim',
            unique_together={('site', 'vendor')},
        ),
    ]
