# local_secrets/users/services/email_service.py
from django.core.mail import EmailMultiAlternatives
from django.template.loader import render_to_string
from django.utils.html import strip_tags
from django.conf import settings

class VendorEmailService:
    @staticmethod
    def send_welcome_email(vendor):
        subject = f'Welcome to Local Secrets, {vendor.company_name}!'
        context = {
            'vendor': vendor,
            'dashboard_url': f"{settings.FRONTEND_URL}/vendor/dashboard"
        }
        
        html_content = render_to_string('emails/vendor/welcome_email.html', context)
        text_content = strip_tags(html_content)
        
        msg = EmailMultiAlternatives(
            subject,
            text_content,
            settings.DEFAULT_FROM_EMAIL,
            [vendor.contact_email]
        )
        msg.attach_alternative(html_content, "text/html")
        msg.send()

    @staticmethod
    def send_verification_update(vendor, status, rejection_reason=None):
        subject = f'Business Verification Update - {vendor.company_name}'
        context = {
            'vendor': vendor,
            'status': status,
            'rejection_reason': rejection_reason,
            'dashboard_url': f"{settings.FRONTEND_URL}/vendor/verification"
        }
        
        html_content = render_to_string('emails/vendor/verification_email.html', context)
        text_content = strip_tags(html_content)
        
        msg = EmailMultiAlternatives(
            subject,
            text_content,
            settings.DEFAULT_FROM_EMAIL,
            [vendor.contact_email]
        )
        msg.attach_alternative(html_content, "text/html")
        msg.send()

