# local_secrets/users/tests/test_analytics.py

from django.test import TestCase
from django.utils import timezone
from datetime import timedelta
from ..services.analytics_service import SubscriptionAnalytics
from ..models import VendorSubscription, SubscriptionPlan, Vendor
from .factories import VendorFactory, SubscriptionPlanFactory

class SubscriptionAnalyticsTests(TestCase):
    def setUp(self):
        self.vendor = VendorFactory()
        self.plan = SubscriptionPlanFactory()
        self.subscription = VendorSubscription.objects.create(
            vendor=self.vendor,
            plan=self.plan,
            start_date=timezone.now(),
            end_date=timezone.now() + timedelta(days=30),
            status='active'
        )

    def test_subscription_overview(self):
        overview = SubscriptionAnalytics.get_subscription_overview()
        self.assertIn('active_subscriptions', overview)
        self.assertIn('revenue', overview)
        self.assertIn('avg_subscription_duration', overview)
        self.assertIn('churn_rate', overview)

    def test_subscription_trends(self):
        trends = SubscriptionAnalytics.get_subscription_trends()
        self.assertIn('new_subscriptions', trends)
        self.assertIn('cancellations', trends)
        self.assertIn('revenue_trend', trends)

    def test_plan_performance(self):
        performance = SubscriptionAnalytics.get_plan_performance()
        self.assertTrue(len(performance) > 0)
        self.assertIn('active_subscriptions', performance[0])
        self.assertIn('total_revenue', performance[0])
