from local_secrets.core import constants as const


class EmailTranslationManager:

    """
    A service class responsible for dynamically translating email templates and messages
    based on the user's preferred language. It ensures that all email notifications
    are localized to improve user experience.
    """

    def __init__(self, language: str):
        self.language = language

    def localize(self, template: int, context: dict = None):
        """
        Localize email content for 
         - Email verification template.
         - Email verification success template.
         - Password recovery email template
        """

        if template == const.USER_EMAIL_VERIFICATION_TEMPLATE_ID:
            recipient = context.get("recipient", "")
            expiration_in = const.ACTIVATION_EXPIRATION_IN_SECONDS / 3600

            translation = {
                "en": {
                    "subject": "Confirm your email address",
                    "heading": "Confirm your email address to start using Local Secrets",
                    "body": f"Once you confirm that {recipient} is your email address, you can access Local Secrets.",
                    "verify_text": "Click the button to verify:",
                    "button_text": "Verify your email",
                    "footer": "If you didn't request this email, you can ignore it.",
                    "activation_link_info_text": f"This link is valid for {expiration_in} hours. If it expires, you’ll be able to request a new one next time you log in."
                },
                "en_GB": {
                    "subject": "Confirm your email address",
                    "heading": "Confirm your email address to start using Local Secrets",
                    "body": f"Once you confirm that {recipient} is your email address, you can access Local Secrets.",
                    "verify_text": "Click the button to verify:",
                    "button_text": "Verify your email",
                    "footer": "If you didn't request this email, you can ignore it.",
                    "activation_link_info_text": f"This link is valid for {expiration_in} hours. If it expires, you’ll be able to request a new one the next time you log in."
                },
                "es": {
                    "subject": "Confirma tu dirección de correo electrónico",
                    "heading": "Confirma tu dirección de correo electrónico para empezar a usar Local Secrets",
                    "verify_text": "Haz clic en el botón para verificar:",
                    "body": f"Una vez que confirmes que {recipient} es tu dirección de correo electrónico, podrás acceder a Local Secrets.",
                    "button_text": "Verifica tu correo electrónico",
                    "footer": "Si no solicitaste este correo electrónico, puedes ignorarlo.",
                    "activation_link_info_text": f"Este enlace es válido durante {expiration_in} horas. Si caduca, podrás solicitar uno nuevo la próxima vez que inicies sesión."
                },
                "fr": {
                    "subject": "Confirmez votre adresse e-mail",
                    "heading": "Confirmez votre adresse e-mail pour commencer à utiliser Local Secrets",
                    "body": f"Une fois que vous aurez confirmé que {recipient} est votre adresse e-mail, vous pourrez accéder à Local Secrets.",
                    "verify_text": "Cliquez sur le bouton pour vérifier :",
                    "button_text": "Vérifiez votre e-mail",
                    "footer": "Si vous n'avez pas demandé cet e-mail, vous pouvez l'ignorer.",
                    "activation_link_info_text": f"Ce lien est valable pendant {expiration_in} heures. S’il expire, vous pourrez en demander un nouveau lors de votre prochaine connexion."
                }
            }

        elif template == const.USER_EMAIL_VERIFICATION_SUCCESS_TEMPLATE_ID:
            translation = {
                "en": {
                    "subject": "Your email has been successfully verified!",
                    "heading": "Congratulations! You are now part of the Local Secrets community!",
                    "body": "Your email has been successfully verified. You can now enjoy all the services we offer on the website.",
                    "button_text": "Website link"
                },
                "en-GB": {
                    "subject": "Your email has been successfully verified!",
                    "heading": "Congratulations! You are now part of the Local Secrets community!",
                    "body": "Your email has been successfully verified. You can now enjoy all the services we offer on our website.",
                    "button_text": "Visit Website"
                },
                "es": {
                    "subject": "¡Tu dirección de correo electrónico ha sido verificada con éxito!",
                    "heading": "¡Enhorabuena! Ahora formas parte de la comunidad de Local Secrets.",
                    "body": "Tu correo electrónico ha sido verificado correctamente. Ahora puedes disfrutar de todos los servicios que ofrecemos en nuestro sitio web.",
                    "button_text": "Visitar el sitio web"
                },
                "fr": {
                    "subject": "Votre adresse e-mail a été vérifiée avec succès !",
                    "heading": "Félicitations ! Vous faites maintenant partie de la communauté Local Secrets !",
                    "body": "Votre adresse e-mail a été vérifiée avec succès. Vous pouvez désormais profiter de tous les services que nous offrons sur notre site web.",
                    "button_text": "Visiter le site web"
                }
            }

        elif template == const.USER_FORGOT_PASSWORD_TEMPLATE_ID:
            password = context.get("password", "")
            translation = {
                "en": {
                    "subject": "Your new password has been generated",
                    "heading": "Here is your new password for Local Secrets",
                    "body": "You requested a password reset for your Local Secrets account.",
                    "password_info_text": f"Your new generated password is: {password}",
                    "instructions": "Use this password to log in to your account. For security, we recommend changing it after logging in.",
                    "footer": "If you didn't request this password reset, please ignore this email.",
                },
                "en-GB": {
                    "subject": "Your new password has been generated",
                    "heading": "Here is your new password for Local Secrets",
                    "body": "You requested a password reset for your Local Secrets account.",
                    "password_info_text": f"Your new generated password is: {password}",
                    "instructions": "Use this password to log in to your account. For security, we recommend changing it after logging in.",
                    "footer": "If you didn't request this password reset, please ignore this email."
                },
                "es": {
                    "subject": "Se ha generado tu nueva contraseña",
                    "heading": "Aquí tienes tu nueva contraseña para Local Secrets",
                    "body": "Has solicitado restablecer la contraseña de tu cuenta de Local Secrets.",
                    "password_info_text": f"Tu nueva contraseña es: {password}",
                    "instructions": "Utiliza esta contraseña para iniciar sesión en tu cuenta. Por seguridad, te recomendamos cambiarla después de iniciar sesión.",
                    "footer": "Si no solicitaste este restablecimiento, puedes ignorar este correo."
                },
                "fr": {
                    "subject": "Votre nouveau mot de passe a été généré",
                    "heading": "Voici votre nouveau mot de passe pour Local Secrets",
                    "body": "Vous avez demandé la réinitialisation du mot de passe de votre compte Local Secrets.",
                    "password_info_text": f"Votre nouveau mot de passe est : {password}",
                    "instructions": "Utilisez ce mot de passe pour vous connecter à votre compte. Pour plus de sécurité, nous vous recommandons de le changer après connexion.",
                    "footer": "Si vous n'avez pas demandé cette réinitialisation, vous pouvez ignorer cet e-mail."
                }
            }

        return translation.get(self.language)